-- Zadatak 3
-- Prebacimo se na bazu AdventureWorksOBP
USE AdventureWorksOBP;

-----------------------------------------------------------------
-- 3a) Ispiite popis rauna (datum, ukupan iznos, naziv kupca)
-- pripremni upiti
SELECT * FROM Kupac;
SELECT * FROM Racun;
SELECT * FROM Stavka;
-- zavrni upit
SELECT DISTINCT
	Racun.DatumIzdavanja AS 'Datum',
	Stavka.UkupnaCijena AS 'Ukupan iznos',
	Kupac.Ime+' '+Kupac.Prezime AS 'Kupac'
FROM Racun
INNER JOIN Kupac  ON Kupac.IDKupac  = Racun.KupacID
INNER JOIN Stavka ON Stavka.RacunID = Racun.IDRacun;
-----------------------------------------------------------------

-----------------------------------------------------------------
-- 3b) Za nekog kupca ispiite svu robu koju je kupovao.
-- pripremni upiti
SELECT * FROM Kupac;
SELECT * FROM Racun;
SELECT * FROM Stavka;
SELECT * FROM Proizvod;
-- zavrni upit
SELECT DISTINCT
	Kupac.Ime+' '+Kupac.Prezime AS 'Kupac',
	Proizvod.Naziv AS 'Proizvod'
FROM Racun
INNER JOIN Kupac    ON Kupac.IDKupac  = Racun.KupacID
INNER JOIN Stavka   ON Stavka.RacunID = Racun.IDRacun
INNER JOIN Proizvod ON Proizvod.IDProizvod = Stavka.ProizvodID
WHERE Kupac.IDKupac = 1;
-----------------------------------------------------------------

-----------------------------------------------------------------
-- 3c) Za nekog kupca ispiite koje je sve kategorije robe ikada naruio.
-- pripremni upiti
SELECT * FROM Kupac;
SELECT * FROM Racun;
SELECT * FROM Stavka;
SELECT * FROM Proizvod;
SELECT * FROM Potkategorija;
-- zavrni upit
SELECT DISTINCT
	Kupac.Ime+' '+Kupac.Prezime AS 'Kupac',
	Potkategorija.Naziv AS 'Kategorija'
FROM Racun
INNER JOIN Kupac         ON Kupac.IDKupac  = Racun.KupacID
INNER JOIN Stavka        ON Stavka.RacunID = Racun.IDRacun
INNER JOIN Proizvod      ON Proizvod.IDProizvod = Stavka.ProizvodID
INNER JOIN Potkategorija ON Proizvod.PotkategorijaID = Potkategorija.IDPotkategorija
WHERE Kupac.IDKupac = 1;
-----------------------------------------------------------------

-----------------------------------------------------------------
-- 3d) Za neki proizvod ispiite sve njegove podkategorije i kategorije.
-- pripremni upiti
SELECT * FROM Proizvod;
SELECT * FROM Potkategorija;
SELECT * FROM Kategorija;
-- zavrni upit
SELECT DISTINCT
	Proizvod.Naziv AS 'Naziv proizvoda',
	Kategorija.Naziv AS 'Kategorija',
	Potkategorija.Naziv AS 'Potkategorija'
FROM Proizvod
INNER JOIN Potkategorija ON Proizvod.PotkategorijaID = Potkategorija.IDPotkategorija
INNER JOIN Kategorija    ON Potkategorija.KategorijaID = Kategorija.IDKategorija
WHERE Proizvod.IDProizvod = 771;
-----------------------------------------------------------------

